
#include "Hephaestos.h"

#if defined(ARDUINO) && ARDUINO >= 100
    #include "Arduino.h"
#else
    #include "WProgram.h"
#endif

#include "HardwareSerial.h"

HEPHAESTOS::HEPHAESTOS()
{
     hephdatalenght=0;
    for(int i=0;i<maxLength;i++)
    {
     Hephdata[i]=0;

    }
     hephinString = String(maxLength);
    hephposstring=0;
    hephisreading=false;
    hephcouldread=true;
    mselipsed=0;
}

void HEPHAESTOS::begin(Stream &serial, const int baudrate)
{
    _serial = &serial;
    _hephbaud=baudrate;

}

void HEPHAESTOS::setSerial(Stream &serial, const int baudrate)
{
    _serial = &serial;
    _hephbaud=baudrate;

}

bool HEPHAESTOS::available() {
    return _serial->available();
}

void HEPHAESTOS::checkSerial()
{
    hephisreading=false;

     if (_serial->available() > 0)
   {
     hephisreading=true;
    char inChar =_serial->read();

       if (hephinString.length() <maxLength )
       {
        hephinString+=inChar;
        hephposstring++;
       }
       else
        {
         hephposstring=0;
         hephinString = "";
        }
    if(hephposstring>=4)
    {
    hephaestosReadOrder();
    }
   }
}

void HEPHAESTOS::setToHephaestos(byte buffer[], int buffersize)
{
    if(buffersize<513)
      {
      int timewidth = (buffersize*4*8)/(_hephbaud/1000);
      if(hephcouldread)
      {
        if(millis()<mselipsed)
        {
           mselipsed=millis();
        }
        if(millis()>mselipsed+timewidth)
        {

     mselipsed=millis();
                _serial->write((byte)START_MESSAGE);
                 _serial->write((byte)READ_SERIAL_LABEL);
                _serial->write((byte)(buffersize+2)%256);
                _serial->write((byte)(buffersize+2)/256);
                _serial->write((byte)0);
               _serial->write((byte)0);
			  
                _serial->write(buffer,buffersize);
				
                 _serial->write((byte)END_MESSAGE);
    }
        }
      }

}

void HEPHAESTOS::hephaestosReadOrder()
{
    int index = hephinString.indexOf((char)START_MESSAGE);

   if (hephinString[index]==(char)START_MESSAGE)
   {

     int taille = ((byte)hephinString[3+index]*256)+(byte)hephinString[2+index];
     if(hephinString.length()>=taille+4+index)
     {
       if(hephinString[taille+4+index]==(char)END_MESSAGE)
   {
       if(hephinString[1+index]==(char)ARDUINO_IDENTIFY_LABEL)
   {
   hephaestosGiveId();
   }

   if(hephinString[1+index]==(char)ARDUINO_SHOULDREAD_LABEL)
   {
   if(hephinString[4+index]>(char)33)
   {

     hephcouldread=true;
   }
   else
   {

     hephcouldread=false;
   }
   }

   if(hephinString[1+index]==(char)WRITE_SERIAL_LABEL)
   {

     byte outputbuffer[taille-1];
     for(int i=0;i<taille-1;i++)
     {
       outputbuffer[i]=(byte)hephinString[5+index+i];
     }
     hephaestosFromOutput(outputbuffer, taille);


   }
   hephinString="";
   hephposstring=0;
   }
     }
   }
   else
   {
     hephinString="";
     hephposstring=0;
   }
}

void HEPHAESTOS::hephaestosGiveId()
{
    byte reply [9];
       reply[0]=(byte)START_MESSAGE;
       reply[1]=(byte)ARDUINO_IDENTIFY_LABEL;
       reply[2]=(byte)4;
       reply[3]=(byte)0;
       reply[4]='A';
       reply[5]='R';
       reply[6]='D';
       reply[7]='U';
       reply[8]=(byte)END_MESSAGE;

	 
       _serial->write(reply,9);
       
     hephcouldread=true;
}

void HEPHAESTOS::hephaestosFromOutput(byte buffer[], int buffersize)
{
    hephdatalenght=buffersize;
   if (hephdatalenght<maxLength)
   {
     for(int i=0;i<hephdatalenght;i++)
     {
     Hephdata[i]=buffer[i];
     }
   }
}

byte HEPHAESTOS::getFromHephaestos(int num)
{
    if(num>=0&&num<hephdatalenght)
     {
       return Hephdata[num];
     }
     return 0;
}

int HEPHAESTOS::hephBufferSize()
{
 return hephdatalenght;
}
