#ifndef HEPHAESTOS_H
#define HEPHAESTOS_H

#if defined(ARDUINO) && ARDUINO >= 100
    #include "Arduino.h"
#else
    #include "WProgram.h"
#endif

#include <inttypes.h>

#define maxLength 522
#define START_MESSAGE 0x7e
#define END_MESSAGE 0xe7
#define READ_SERIAL_LABEL 0x05
#define WRITE_SERIAL_LABEL 0x06
#define ARDUINO_IDENTIFY_LABEL 0xa7
#define ARDUINO_SHOULDREAD_LABEL 0x7a


class HEPHAESTOS
{
public:
    HEPHAESTOS();
    void begin(Stream &serial, const int baudrate);
    void setSerial(Stream &serial, const int baudrate);
    bool available();
    void checkSerial();
    void setToHephaestos(byte buffer[], int buffersize);
    int hephBufferSize();
    byte getFromHephaestos(int num);

private:
int hephdatalenght;
byte Hephdata[maxLength];
int _hephbaud;
String hephinString;
int hephposstring;
bool hephisreading;
bool hephcouldread;
unsigned long mselipsed;

Stream* _serial;

void hephaestosReadOrder();
void hephaestosGiveId();
void hephaestosFromOutput(byte buffer[], int buffersize);
};

#endif // HEPHAESTOS_H
